var infoButton = null;
var doneButton = null;
var alarm = {
	'sound': 'none',
	'voice': 'none',
	'growl': false
};

/**
 * Add all event listeners when the window is loaded.
 */
$(window).load(function() {	
	timer = new Timer();
	updater = new Updater();
	front = new Front();
	back = new Back();
	infoButton = new AppleInfoButton($('#infoButton').get(0),
		$('#front').get(0), 'white', 'white', showBack);
	doneButton = new AppleGlassButton($('#doneButton').get(0),
		getLocalizedString('Done'), showFront);
	
	if (window.widget) {
		widget.onremove = remove;
		widget.onhide = hide;
		widget.onshow = show;
	}
	
	loadLocalizedStrings();
	loadPreferences();
});

/**
 * Load all localized strings.
 */
function loadLocalizedStrings() {
	// Front side
	$('#timerTarget').text(getLocalizedString('Tea'));
	$('#readyIn').text(getLocalizedString('ready in'));
	$('#readyInInput > option:nth-child(1)').text(
			getLocalizedString('ready in'));
	$('#readyInInput > option:nth-child(2)').text(
			getLocalizedString('in'));
	$('#hoursLabel').text(getLocalizedString('hrs.'));
	$('#minutesLabel').text(getLocalizedString('mins.'));
	$('#secondsLabel').text(getLocalizedString('secs.'));
	
	// Back side
	$('#homeLink > a').text(getLocalizedString('Tea Timer website'));
	$('#prefBgColorLabel').text(getLocalizedString('Background color') + ':');
	$('#backgroundColor > option[value=default]')
			.text(getLocalizedString('Default'));
	$('#backgroundColor > option[value=cayenne]')
			.text(getLocalizedString('Cayenne'));
	$('#backgroundColor > option[value=graphite]')
			.text(getLocalizedString('Graphite'));
	$('#backgroundColor > option[value=lime]')
			.text(getLocalizedString('Lime'));
	$('#backgroundColor > option[value=ocean]')
			.text(getLocalizedString('Ocean'));
	$('#backgroundColor > option[value=orange]')
			.text(getLocalizedString('Orange'));
	$('#backgroundColor > option[value=purple]')
			.text(getLocalizedString('Purple'));
	$('#backgroundColor > option[value=silver]')
			.text(getLocalizedString('Silver'));
	$('#alarmVoiceLabel').text(getLocalizedString('Voice') + ':');
	$('#alarmVoice > option:first').text(getLocalizedString('Off'));
	$('#alarmSoundLabel').text(getLocalizedString('Sound') + ':');
	$('#alarmSound > option:first').text(getLocalizedString('Off'));
	$('#alarmGrowlLabel').text(getLocalizedString('Use Growl'));
	$('#alarmKeepAlarmingLabel').text(getLocalizedString('Keep Alarming'));
	$('#alarmKeepAlarmingLabel').attr('title', getLocalizedString('Stop it via the alarm clock on the front side.'));
	
	
	// Update panel
	$('#updateLabel').text(getLocalizedString('Update available'));
	$('#clientVersionLabel').text(getLocalizedString('Your version') + ':');
	$('#availableVersionLabel').text(getLocalizedString('New version') + ':');	
}

/**
 * Load and restore the user preferences.
 */
function loadPreferences() {
	if (window.widget) {
		var buf = prefForKey(widget.identifier, 'background');
		if (buf != null) {
			$('#front').css('background', 'url(Images/Front_' + buf
				+ '.png) no-repeat');
			$('#backgroundColor').attr('value', buf);
		}
		buf = prefForKey(widget.identifier, 'timerTarget');
		if (buf != null) {
			$('#timerTarget').text(buf);
		}
		buf = prefForKey(widget.identifier, 'readyIn');
		if (buf != null) {
			$('#readyIn').text(buf);
		}
		buf = prefForKey(widget.identifier, 'hours');
		if (buf != null) {
		    $('#hours').text(front.formatTwoDigits(buf));
		}
		buf = prefForKey(widget.identifier, 'minutes');
		if (buf != null) {
		    $('#minutes').text(front.formatTwoDigits(buf));
		}
		buf = prefForKey(widget.identifier, 'seconds');
		if (buf != null) {
		    $('#seconds').text(front.formatTwoDigits(buf));
		}
		buf = prefForKey(widget.identifier, 'alarm.sound');
		if (buf != null) {
			alarm.sound = buf;
			$('#alarmSound').attr('value', buf);
		}
		buf = prefForKey(widget.identifier, 'alarm.voice');
		if (buf != null) {
			alarm.voice = buf;
			$('#alarmVoice').attr('value', buf);
		}
		buf = prefForKey(widget.identifier, 'alarm.growl');
		if (buf != null) {
			alarm.growl = buf;
			if (buf == 'on')
				$('#alarmGrowl').attr('checked', 'checked');
		}
		buf = prefForKey(widget.identifier, 'alarm.keepAlarming');
		if (buf != null) {
			alarm.keepAlarming = buf;
			if (buf == 'on')
				$('#alarmKeepAlarming').attr('checked', 'checked');
		}
	}
}

/**
 * Try to get a pref either for a widget instance or the default value.
 *
 * @param id: widget identifier
 * @param key: preference key
 * @return: The preference or null
 */
function prefForKey(id, key) {
    var buf = widget.preferenceForKey(widget.identifier + '-' + key);
	if (buf && buf.length > 0) {
		return buf
	}
	
	buf = widget.preferenceForKey(key);
	if (buf && buf.length > 0) {
	    return buf
	}
    
    return null
}

/**
 * Set a preference for a widget instance and as default value.
 *
 * @param value: preference value
 * @param id: widget identifier
 * @param key: preference key
 */
function setPrefForKey(value, id, key) {
    if (!window.widget)
        return;
    
    widget.setPreferenceForKey(value, id + '-' + key);
    widget.setPreferenceForKey(value, key);
}

/**
 * Get a localized string for a key.
 *
 * @param key: Search string for that key.
 * @return: The localized string if found, else the key.
 */
function getLocalizedString(key)
{
	try {
		var ret = localizedStrings[key];
		if (ret === undefined)
			ret = key;
		return ret;
	} catch (ex) {}
	return key;
}

/**
 * Called when the widget has been removed from the Dashboard.
 */
function remove() {
	// Stop any timers to prevent CPU usage
	// Remove any preferences as needed
	// widget.setPreferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
}

/**
 * Called when the widget has been hidden.
 */
function hide() {
	// Don't stop the timer or you'll forget your tea!
}

/**
 * Called when the widget has been shown.
 */
function show() {
	updater.check();
}

/**
 * Called when the info button is clicked to show the back of the widget.
 *
 * @param event: onClick event from the info button
 */
function showBack(event) {
	if (window.widget) {
		window.resizeTo(320, 150);
		widget.prepareForTransition("ToBack");
	}

	$('#front').css('display', 'none');
	$('#back').css('display', 'block');

	if (window.widget) {
		setTimeout('widget.performTransition();', 0);
	}
}

/**
 * Called when the done button is clicked from the back of the widget.
 *
 * @param event: onClick event from the done button
 */
function showFront(event) {
	if (window.widget) {
		widget.prepareForTransition("ToFront");
		window.resizeTo(320, 120);
	}

	$('#front').css('display', 'block');
	$('#back').css('display', 'none');

	if (window.widget) {
		setTimeout('widget.performTransition();', 0);
	}
}
